<!doctype html>
<html lang="pt-BR">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Redirecionando…</title>
  <meta name="robots" content="noindex">
  <style>
    body {font-family: Arial,Helvetica,sans-serif; display:flex; align-items:center; justify-content:center; height:100vh; margin:0;}
    .box {text-align:center; max-width:420px; padding:16px;}
    a {color:#ffcf00; display:inline-block; margin-top:12px;}
  </style>
</head>
<body>
  <div class="box">
    <h2>Abrindo o app correto…</h2>
    <p>Caso o redirecionamento não funcione, escolha manualmente:</p>
    <p>
      <a id="linkAndroid" href="https://play.google.com/store/apps/details?id=br.com.syspan.zemaltedelivery&hl=pt_BR">Google Play (Android)</a><br>
      <a id="linkIOS" href="https://apps.apple.com/br/app/z%C3%A9-do-malte-delivery/id6754698545">App Store (iOS)</a>
    </p>
  </div>

  <script>
    (function(){
      // URLs das lojas
      var urlAndroid = "https://play.google.com/store/apps/details?id=br.com.syspan.zemaltedelivery&hl=pt_BR";
      var urlIOS = "https://apps.apple.com/br/app/z%C3%A9-do-malte-delivery/id6754698545";
      var ua = navigator.userAgent || navigator.vendor || window.opera;

      // detecção simples iOS vs Android
      var isAndroid = /android/i.test(ua);
      var isIOS = /iPhone|iPad|iPod/i.test(ua);

      // atualiza links visíveis (backup)
      document.getElementById('linkAndroid').href = urlAndroid;
      document.getElementById('linkIOS').href = urlIOS;

      // redireciona com pequeno delay (melhor UX e dá fallback)
      if (isIOS) {
        // no iOS, abrir App Store
        window.location.replace(urlIOS);
      } else if (isAndroid) {
        // no Android, abrir Play Store
        window.location.replace(urlAndroid);
      } else {
        // desktop ou user-agent desconhecido -> mostrar a página com os links
        // mantém o usuário na página (não faz redirect)
      }
    })();
  </script>
</body>
</html>
